#include "stdio.h"
#include "conio.h"
#include "stdlib.h"
#define SIZE 5
struct queue{
   int items[SIZE];
   int front;
   int rear;
};
int  empty(queue *);
void addQ(queue *, int, int *);
void retrieve(queue *, int *, int *);
void qremove(queue *, int *, int *);
void print(queue *);
int menu();
int main()
{
   queue q;
   q.front = q.rear = 0;
   int x, overflow, underflow;
   while(1)
   {
      clrscr();
      switch(menu())
      {
	 case 1:
	      print(&q);
	      break;
	 case 2:
	      printf("Enter a value to enter q:");
	      scanf("%d", &x);
	      addQ(&q, x, &overflow);
	      if(overflow)
	      {
		 printf("queue is full. press a key to continue.");
		 getch();
	      }
	      break;
	 case 3:
	      qremove(&q, &x, &underflow);
	      if(underflow)
	      {
		 printf("queue is empty. press a key to continue.");
		 getch();
	      }
	      break;
	 case 4:
	      retrieve(&q, &x, &underflow);
	      if(underflow)
	      {
		 printf("queue is empty. press a key to continue.");
		 getch();
	      }
	      else
	      {
		 printf("Retrieved value is:%d", x);
		 getch();
	      }
	      break;
	 case 5:
	      exit(1);
      }//end of switch
    }//end of while
}//end of program
//********************
int  empty(queue *q)
{
   if(q -> rear == q -> front)
       return 1;
    return 0;
}
//********************
void addQ(queue *q, int x, int *overflow)
{
   int newRear;
   newRear = ((q -> rear) + 1) % SIZE;
   if((q->front) == newRear)
       *overflow = 1;
   else
   {
      *overflow = 0;
      q -> items[q -> rear] = x;
      q -> rear = newRear;
   }
}
//********************
void retrieve(queue *q, int *x, int *underflow)
{
   if(empty(q))
       *underflow = 1;
   else
   {
       *underflow = 0;
       *x = q -> items[q -> front];
   }
}
//********************
void qremove(queue *q, int *x, int *underflow)
{
   if(empty(q))
       *underflow = 1;
   else
   {
       *underflow = 0;
       *x = q -> items[(q -> front)];
       q -> front = ((q -> front) + 1) %  SIZE;
   }
}
//********************
void print(queue *q)
{
  int i;
  if(empty(q))
     printf("Queue is empty.");
  else
  {
    if(q -> front < q -> rear)
     for(i = q -> front; i < q -> rear; i ++)
       printf("%5d", q -> items[i]);
    else if (q -> front > q -> rear)
    {
      for(i = q -> front; i < SIZE  ; i ++)
	  printf("%5d", q -> items[i]);
      for(i = 0; i < q -> rear; i ++)
	  printf("%5d", q -> items[i]);
    }
  }
  printf("\nPress a key to continue.");
  getch();
}
//*******************
int menu()
{
   int c;
   printf("1. Print queue.\n");
   printf("2. Add to quue.\n");
   printf("3. Remove from queue.\n");
   printf("4. Retrieve from queue.\n");
   printf("5. Exit.\n");
   printf("Enter your select(1-5):");
   scanf("%d", &c);
   return c;
}


